//  triangular matrices

#include <iostream>
#include "tnt.h"
#include "fmat.h"
#include "triang.h"
#include "trislv.h"

using namespace std;
using namespace TNT;

int main()
{
    Fortran_Matrix<double> A(4, 4, 
                                   " 2  1  1  1 "
                                   " 2  3  1  1 "
                                   " 6  7  4  1 "
                                   " 9  2  3  5 " );

    cout << "A : " << A << endl;

    cout <<"Lower triangular part of A: " <<
        Lower_triangular_view(A) << endl;

    cout << "Bottom left 2x2 corner: " <<
        Lower_triangular_view(A)(Index1D(3,4), Index1D(1,2)) << endl;

    cout << "Unit lower triangular part of A: " <<
        Unit_lower_triangular_view(A) << endl;


    Vector<double> b(4, "1 2 3 4");

    Vector<double> x;

    x = linear_solve(Unit_lower_triangular_view(A), b);

    cout << "solution to Unit_lower_triangular_view(A)*x = [1 2 3 4]':  " 
            << x << endl;

    cout << "A*x - b : " << Unit_lower_triangular_view(A)* x - b << endl;

/*
    
    x = linear_solve(Lower_triangular_view(A), b);

    cout << "solution to Lower_triangular_view(A)*x = [1 2 3 4]':  " 
            << x << endl;

    cout << "A*x - b : " << Lower_triangular_view(A)* x - b << endl;

*/
   	return 0; 
}
    
