#include <iostream>
#include "tnt.h"
#include "fspvec.h"

using namespace std;
using namespace TNT;

int main()
{
   const int N=12;

   // build a sparse matrix out of C arrays
   //
   double   values[4]  = { 1.1,   2.1,  3.1, 4.0,};
   Subscript index[4]   = {  2,    5,     1,   7};

    Fortran_Sparse_Vector<double> A(N, 4, 
                                            " 5.1   8.3   6.7   4.2",
                                            "  1     2     3     4");


    Fortran_Sparse_Vector<double> B(N, 4, values, index);
    Fortran_Sparse_Vector<double> C;

    cout << A << endl;
    cout << B << endl;
    cout << C << endl;

    // adjusting elements directly

    A.val(2) = 9.9;
    A.index(2) =  6;

    B = A;

    cout << A << endl;
    cout << B << endl;


    // illustrate reassignments

    B.newsize(N, 3);
    B.val(1) = 1.1;
    B.val(2) = 1.2;
    B.val(3) = 1.3;
    B.index(1) = 7;
    B.index(2) = 8;
    B.index(3) = 9;

    cout << B << endl;

	return 0;
}


