
// Symmetric eigenvalue problem solver
//
// Usage: a.out < a10x10.dat
//
// where matrix.dat is an ASCII file consisting of the
// matrix size (M,N) followed by its values.  For example,
//
//  3  2
//  8.1  1.2  4.3
//  1.3  4.3  2.9
//
//
// Compile line (on g++/g77 systems) looks like
//
// g++ foo.cc -llapack -lblas -lf2c -lm
//



#include <iostream>

#include "tnt.h"
#include "fortran.h"
#include "lapack.h"

using namespace std;

void print_eigs(ostream &s, const Vector<double> &rl, const Vector<double> &im)
{
    Subscript N = rl.dim();
    Subscript i;

    s << N << endl;
    for (i=1; i<=N; i++)
    {
        s << rl(i) ;
        if (im(i) != 0)
            s << " + " << im(i) << "i";
        s << endl;
    }
    s << endl;
}
        
int main()
{
    Fortran_Matrix<double> A;

    cin >> A;           // read in a general matrix
    
    Fortran_Matrix<double> B = (A + transpose(A)) * 0.5;  // make symmetric

    cout << "'symmetrized' matrix : " << B << endl;
    cout << "eigenvalues: " << Upper_symmetric_eigenvalue_solve(B) << endl;

    cout << endl << "original matrix : " << A << endl;

    Vector<double> r;               // eigenvalues (real part)
    Vector<double> i;               //             (img part)

    if (eigenvalue_solve(A, r, i) != 0)
        cout << "eigenvalue error" << endl;
    else
        print_eigs(cout, r,i);

	return 0;
}
