/* defectcnt.c */
/* Code for introducing cylindrical deletions in CNT structure */
/* Kenny Higa, 13 Dec 2002 */

#include <stdio.h>

#define MAXDEFECTS 10

int main(int argc, char *argv[]) {

	int i, defectcount, remove;

	unsigned int bcstatus, ring;

	double x, y, z;

	double deltax, deltaz, distance2;

	double defects[MAXDEFECTS][3];

	FILE *defect, *input, *output;

	if (argc != 4) {
		puts("defectcnt < defects file > < coordinate input file > < output file >\n");
		return 1;
	}

	if ((defect = fopen(argv[1],"r")) == NULL) {
		printf("Error opening defects file %s\n", argv[1]);
		return 2;
	}

	if ((input = fopen(argv[2],"r")) == NULL) {
		printf("Error opening input file %s\n",	argv[2]);
		return 2;
	}	

	if ((output = fopen(argv[3],"w")) == NULL) {
		printf("Error opening output file %s\n", argv[3]);
		return 2;
	}

	/*	first load list of defects */
	/*	defect file has the following format:
		
		x	y	r

		where x and y are the coordinates of the central axis of the
		horizontal (extends in z direction) cylinder of square radius
		r in which all particles are removed from the coordinate file.
	*/

	defectcount = 0;
	while ((fscanf(defect,"%lf %lf %lf", &defects[defectcount][0], &defects[defectcount][1], &defects[defectcount][2])) != EOF) 
		defectcount++;

	/* close defect, since we don't need it any more */
	
	fclose(defect);	

	while ((fscanf(input, "%lf %lf %lf %u %u", &x, &y, &z, &bcstatus, &ring)) != EOF) {
		remove = 0;
		for (i = 0; i < defectcount; i++) { 
			deltax = x - defects[i][0];
			deltaz = z - defects[i][1];
			distance2 = deltax * deltax + deltaz * deltaz;

			if (distance2 <= defects[i][2] * defects[i][2]) {
				remove = 1;
				break;
			}
		}
		
		if (!remove)
			fprintf(output, "%lf\t%lf\t%lf\t%u\t%u\n", x, y, z, bcstatus, ring);	
	}

	/* finish nicely */

	fclose(input);
	fclose(output);

	return 0;
} 
