/* findring.c */
/* Code for shifting atoms in CNT so that none have negative x coordinates */
/* Kenny Higa, 16 Dec 2002 */

#include <stdio.h>
#include <math.h>

#define EPSILON 0.01
#define MAXRINGS 100

int setpos(double x, double *ringpos, unsigned int ringcount) {

  unsigned int i;

  for (i = 0; i < ringcount; i++) {

    if (fabs(x - ringpos[i]) < (double) EPSILON)
      return i;

  }

  ringpos[ringcount++] = x;

  return ringcount;

}

void setrank(double max, int *ringrank, double *ringpos, int ringcount) {

  unsigned int lowestpos, i, j;
  double lowerbound = -1.0;
  double lowestval;

  for (i = 1; i <= ringcount; i++) {

    lowestval = max + 1.0;
    
    for (j = 0; j < ringcount; j++) {

      if (ringpos[j] < lowestval && ringpos[j] > lowerbound) {
	lowestval = ringpos[j];
	lowestpos = j;

      }

    }
    lowerbound = lowestval;

    ringrank[lowestpos] = i;

  }
}

int main(int argc, char *argv[]) {

	double max, x, y, z;
	double ringpos[MAXRINGS];
	unsigned int ringrank[MAXRINGS];
	unsigned int ringcount, retval;
	unsigned int bc;

	FILE *input, *output;

	if (argc != 3) {
		puts("findring < coordinate input file > < output file >\n");
		return 1;
	}

	if ((input = fopen(argv[1],"r")) == NULL) {
		printf("Error opening input file %s\n",	argv[1]);
		return 2;
	}

	if ((output = fopen(argv[2],"w")) == NULL) {
		printf("Error opening output file %s\n", argv[2]);
		return 2;
	}

	max = 0.0;

	ringcount = 0;

	while ((fscanf(input,"%lf %lf %lf %u", &x, &y, &z, &bc)) != EOF) {
	  if ((retval = setpos(x,ringpos,ringcount)) > ringcount)
	    ringcount = retval;

	  if (x > max)
	    max = x;
	}

	setrank(max, ringrank, ringpos, ringcount);

	/* 	go back to start of file */

	rewind(input);

	while ((fscanf(input, "%lf %lf %lf\t%u", &x, &y, &z, &bc)) != EOF) {

	  fprintf(output,"%lf\t%lf\t%lf\t%u\t%u\n", x, y, z, bc,ringrank[setpos(x, ringpos, ringcount)]);
	}

	/* finish nicely */

	fclose(input);
	fclose(output);

	return 0;
} 
