%%%%%%%%%%%%%% Writen by K.A.Bulashevich ,revised by Xu Yang Nov.14,2002
%%%%%%%%%%% This is a try to make self-consistent solution 

%%%%%%%%%%% Using the solving integral equation by Mathematica

%%%%%%%%%%%%%%%%%%%%%% T=300 K

%%%%%%%%%%%% Useful constants*
pi=acos(-1);

e2nu=2*1.59404;   %%density of states vm:
e2nm=4.8*4.8/(1.6*10);  %4*pi*epsi*aigonm
V=5;
h=5;
a=0.142;    % nm scale 
aL=2*a*sqrt(3)/2;
ntindex=10;
R=3*a*ntindex/(2*pi);
gamma0=2.7;

shod=10;
%%%%%%%%%%%%Version 2.0  start 1
%niter=
%input('Enter the number of iterations');
niter=2;
Nscale=1;
%nstep=input('Enter the number of points between two neighbour atoms (for example 21,41) ');
nstep=21;
boxscale=3;
%fignum=1;
%kT=0.001*input('Enter thermal energy kT in meV (26 for room temperature):   ');
kT=0.026;
%%%%%%%%%%%%Version 2.0  end  1


%%%%%%%%%%%%% Number of atoms and of iterations, temperature

coord=load('defect100.dat');    %%%%Read the files about the coordiates of atoms 
coord(:,1:3)=coord(:,1:3)/10; %change SCI to nm  
[Natom,Dimension]=size(coord);

n= max(coord(:,5)); % row 5 contains ring numbers
n = floor(n / 2);
%%%%%% set the integer %%%_______________need to  impove_______
%%%%%%%%%%%%%%%%%%%%%% Initializing interesting quantities
xax=zeros(n,1);
xaxnm=zeros(n,1);
for i=1:n
 xax(i)=i; 
 xaxnm(i)=i*aL;
end


phi1=zeros(n,1);


%%% record the boundary shape of the nanotube%%%%%%%%%%
MaxY=zeros(n,1);
MinY=zeros(n,1);

for i=1:n
 
   MaxY(i,1)=min(coord(:,3));
  MinY(i,1)=max(coord(:,3)); 
  for j=1:Natom
    if (coord(j,5) == 2*i) | (coord(j,5) == 2*i - 1)
      if MaxY(i,1) < coord(j,3)
        MaxY(i,1) = coord(j,3);
      elseif MinY(i,1) > coord(j,3)
        MinY(i,1) = coord(j,3);
      end
    end
  end
end

 MaxY(:,1) =MaxY(:,1)+h;
 MinY(:,1) =MinY(:,1)+h;


%%%%%%%%%%%%%%%     Hopping part of the hamiltonian
tbam=zeros(2*n);

%%%%% Here i - number of the layer
%%%%%% Then atom A of layer i has number 2*i-1
%%%%%% Then atom B of layer i has number 2*i
for i=1:n,
   tbam(2*i,2*i-1)=1;
   tbam(2*i-1,2*i)=1;
   if i>1
     tbam(2*(i-1)-1,2*i)=1;
     tbam(2*(i-1),2*i-1)=1;
     tbam(2*i-1,2*(i-1))=1;
    tbam(2*i,2*(i-1)-1)=1;
   end;
end;
tbam=-tbam*gamma0;
%%%%%%%%%%%%%%%%%%%%%% Initializing interesting quantities - ne, rho, energies etc
ne=zeros(niter,1);
energies=zeros(2*n,niter);
rho=zeros(n,niter);
phisc=zeros(n,niter);


%%%%%%%%%%%%Version 2.0 start  2
%            Apply coordinate from the MD to Qautumn                             */
tmpphiext=zeros(Natom,1);
phiext=zeros(n,1);
kindex=zeros(n,1);

for i=1:n
kindex(i)=0;
end

for i=1:Natom 
  %tmpphiext(i)=(V*(2/pi)*atan(coord(i,1)/(coord(i,3)+h)))+0.8*exp(-coord(i,1)/100)+tmpphiext(i); 
%   tmpphiext(i)=(V*(2/pi)*atan(coord(i,1)/(coord(i,3)+h)))-0.8*exp(-coord(i,1)/10)+tmpphiext(i); 
 tmpphiext(i)=V*(2/pi)*atan(coord(i,1)/(coord(i,3)+h));
  k=floor(abs(coord(i,1))/aL)+1;
  if k>n
    k=n;
  end

  kindex(k)=kindex(k)+1;
  phiext(k)=phiext(k)+tmpphiext(i);
end;



for k=1:n
  if kindex(k)>0
  phiext(k)=phiext(k)/kindex(k);    %(for all of the atoms) 
  end

end;


%%%%%%%%%%%%Version 2.0  end  2

a1=aL;

%%%%%%%%%%%%%%%%%           Tabulating the expression in the figure brackets
figbra=zeros(2*n+1,1);
for i=1:2*n+1;
  if i>1
    zi=(i-1)*a1;
    figbra(i)=(2/(pi*zi))*(1/sqrt(1+4*R*R/(zi*zi)))*ellipke((4*R*R/(zi*zi))/(1+4*R*R/(zi*zi)))-.......
           1/sqrt(zi*zi+4*h*h);
   else
    figbra(i)=(1-log(a1/(16*R)))/(pi*R)-1/(2*h);
    ii=i;
  end
end

Ham=zeros(n,n);

for i=1:n
  for j=1:n
    Ham(i,j)=figbra(abs(i-j)+1)-figbra(i+j+1);    
  end;
end;

for i=1:n
Ham(i,i)=Ham(i,i)+1/(e2nu*aL);
end;

;  %% solve the matrix;
phi=zeros(n,1);
phiinf=zeros(n,1);

sHam = sparse(Ham);
sphi=(sHam\phiext)/(e2nu*aL);
phi=full(sphi);
phiinf=phi;

rho0=zeros(n,1);
rho0=phi*e2nu;


%%%%%%%%%%%%%%%%%%%%%%%%%   Version 2.0  start 3

phi1=zeros(n,1);



%%%%%%%%%%%%%%%%%%%%%%%%%   Version 2.0  end  3

%%%%%%%%%%%%%%%%%%%%%%%%%   Version 2.0 start  4

%%%%%%%%%%%%%%%%%%%%%%%%%   Version 2.0  end  4


%%%%%2D-possion solver start


NX=Nscale*n*boxscale;
NY=floor(Nscale*h*boxscale/aL)+1;
 aLL=aL/Nscale;
%A=zeros(NX*NY,NX*NY);
%P=zeros(NX*NY,1);
%PHI=zeros(NX*NY,1);

xpts = ones(1,5*(NY-2)*(NX-2)+2*NX+2*NY);
ypts = ones(1,5*(NY-2)*(NX-2)+2*NX+2*NY);
s = ones(1,5*(NY-2)*(NX-2)+2*NX+2*NY);
count = 1
%%%%% 2D-poisson solver initial part%%%%%%%%%%%%%
% inner domain
for j=2: NY-1
  for i=2:NX-1

    meI = i+(j-1)*NX;

    xpts(1,count) = meI;
    ypts(1,count) = meI;
    s(1,count) = -4;
    count = count + 1;

    xpts(1,count) = meI;
    ypts(1,count) = meI-1;
    s(1,count) = 1;
    count = count + 1;

    xpts(1,count) = meI;
    ypts(1,count) = meI+1;
    s(1,count) = 1;
    count = count + 1;

    xpts(1,count) = meI;
    ypts(1,count) = meI-NX;
    s(1,count) = 1;
    count = count + 1;

    xpts(1,count) = meI;
    ypts(1,count) = meI+NX;
    s(1,count) = 1;
    count = count + 1;

  end
end

% boundary
for j=1:NY
  for i=1:NX
    meI = i+(j-1)*NX;
    if i==1
      xpts(1,count) = meI;
      ypts(1,count) = meI;
      s(1,count) = 1;
      count = count + 1;      
    end
    if i==NX
      xpts(1,count) = meI;
      ypts(1,count) = meI;
      s(1,count) = 1;
      count = count + 1;         
    end
    if j==1
      xpts(1,count) = meI;
      ypts(1,count) = meI;
      s(1,count) = 1;
      count = count + 1;   
    end
    if j==NY
      xpts(1,count) = meI;
      ypts(1,count) = meI;
      s(1,count) = 1;
      count = count + 1;   
    end

  end
end
A=sparse(xpts,ypts,s,NX*NY,NX*NY);
%%%%% 2D-poisson solver initial part%%%%%%%%%%%%%
% inner domain
%for j=2: NY-1
%  for i=2:NX-1

%    meI = i+(j-1)*NX;

%    A(meI,meI)    = -4;
%    A(meI,meI-1)  = 1;
%    A(meI,meI+1)  = 1;
%    A(meI,meI-NX) = 1;
%    A(meI,meI+NX) = 1;

%  end
%end

% boundary
%for j=1:NY
%  for i=1:NX
%    meI = i+(j-1)*NX;
%    if i==1
%      A(meI,meI) = 1;
%    end
%    if i==NX
%      A(meI,meI) = 1;
%    end
%    if j==1
%      A(meI,meI) = 1;
%    end
%    if j==NY
%      A(meI,meI) = 1;
%    end

%  end
%end




% boundary condition voltage

  %% vertical boundary condition
%for j=0:floor(NY/2)
%   P(1+j*NX)=0;
 % P(1+j*NX)=5*(1-j/NY);%% contact-metal-nanotube boundary condition
%  P((j+1)*NX)=0;
  % P((j+1)*NX)=5*(1-j/NY); %% nanotube tip  boundary condition
%end

%for j=floor(NY/2)+1:NY-1
%  P(1+j*NX)=0;
%  P((j+1)*NX)=0; %% nanotube tip  boundary condition
%end


%%%%%2D-possion solver initial  end



%%%%%%% Self-consist process started!
for iter=1:niter
%iter=1; 

  tic,
  %%%%%%%%%%%%%%%%%%     Adding potential 
  for i=1:n
    tbam(2*i,2*i)=-phi(i);
    tbam(2*i-1,2*i-1)=-phi(i);
  end;

  %%%%%%%%%%%%%%%%%%    Solving matrix
  [wf,en]=eig(tbam);
  if iter<niter
    wf1=wf;
  end
  %%%%%%%%%%%%%%%%%     energies is a vector of energies
  for i=1:2*n
    energies(i,iter)=en(i,i);
    env(i)=en(i,i);
  end
  envs=sort(env);

  %%%%%%%%%%%%%%%%%     Calculating number of occupied states
  for i=1:2*n
    ne(iter)=ne(iter)+2/(1+exp(en(i,i)/kT));
  end;

  %%%%%%%%%%%%%%%%      Calculating rho(z) charge density 
  for i=1:n
    for j=1:2*n
      rho(i,iter)=rho(i,iter)+(abs(wf(2*i,j)*wf(2*i,j))+abs(wf(2*i-1,j)*wf(2*i-1,j)))/(1+exp(en(j,j)/kT));
    end
    rho(i,iter)=2*(rho(i,iter)-1);
  end;
  toc
  rho2=zeros(n,1);
  for i=1:n 
    rho2(i)=rho(i,iter);
  end

  %%%%%%%%%%%%%%%%%      Possion solver operator start 
  
  %%%% inter domain charge density
%  for j=1:n-1
%    for k = floor(MinY(j)/aL):floor(MaxY(j)/aL)
%      P(j+NX*k)=-rho2(j)*aL*aL;
%    end
%  end
  
temp = 0;
  for j= 1:n*Nscale-1
    i=floor(j/Nscale)+1;
    
    temp = temp + floor(MaxY(i,1)/aLL) - floor(MinY(i,1)/aLL) + 1;
  end
  xpts = ones(1,(n*Nscale-1)*temp);
  ypts = ones(1,(n*Nscale-1)*temp);
  s = zeros(1,(n*Nscale-1)*temp);
  count = 1;
 
 %%%%%%%%%% Interpolation of rho
  rho2scale=zeros(n*Nscale,1);
  rho2scale=interpol(rho2,Nscale);
  % Nscale-1 means the number
  % points between the two initial grid, vcut into 2 parts 
  %should input the value of 2-1
  
  for j=1:(n*Nscale-1)
    i=floor(j/Nscale)+1;
    for k = floor(MinY(i,1)/aLL):floor(MaxY(i,1)/aLL)
      xpts(1,count) = j+NX*k;
      s(1,count) = -rho2scale(j)*aLL*aLL;
      count = count + 1;
%      P(j+NX*k)=-rho2(j)*aL*aL;
    end
  end
  P=sparse(xpts,ypts,s,NX*NY,1);
  
%  for i=1:NX
    %% upper boundary condition
%    P(i+(NY-1)*NX)=0; 
    %% bottom contact boundary condition
%   P(i)=0;
    %P(i)=5;
%  end
  
  sPHI=A\P;   %% PHI=invert(A)*P
  PHI=full(sPHI);
   phiindscale=zeros(n*Nscale,1);
  phiind=zeros(n,1);
  
  for j=2:n*Nscale-1
    kindex=0; 
    temp=0;
    i=floor(j/Nscale)+1;

      
        for k = floor(MinY(i,1)/aLL):floor(MaxY(i,1)/aLL)
      temp=temp+PHI(j+NX*k);
      kindex=kindex+1;
    end
    if kindex>0
      temp=temp/kindex;
    end
    phiindscale(j)=temp;
  end
  for i=1:n
    phiind(i,1)=phiindscale(i*Nscale,1);
  end
    phiind=phiind*e2nm;
    phi1=phiind+ phiext;
  

  %%%% possion solver operator end
  
   
  
  %%%%%%%%%%%%% Calculating potential for the next step
  

  %%%%%%%%%% Interpolation of rho
  rho1=zeros(n*nstep,1);
  rho1=interpol(rho2,nstep);
 
 %%%%%%%%%%%% Sum all terms of acting potential

  phi2=zeros(n,1);
  phi2=phi+(phi1-phi)/shod;
  phi=phi2;

  
end           %%%this was end of iteration process


%%%%%%%%%%%%%%%%%%%%%%%%%   Version 2.0 start  5
%tmpphi=zeros(Natom,1);
%tmpphi=tmpphiext+tmpphiind;

%%%%%%%%%%%%%%%%%%%%%%%%%   Version 2.0  end  5
 fid = fopen('chargedensitydft.dat','w');
 fprintf(fid,'%12.8f\n',rho2);
 fclose(fid); %%%% wirte the charge density distribution file output to MD codes



xrho1=zeros(n*nstep,1);
for i=1:n*nstep
   xrho1(i)=i*aL/nstep;
end

%figure
%plot(xax*aL,rho2/aL,xax*aL,rho0);
%title('Quantum charge density compared to the classical charge density ')
%figure
%plot(xrho1,rho1)
%title('Quantum Charge density 1 ')
%figure
%plot(xax,phiext)
%title('external potential different')
%figure
%plot(xax,phi)
%title('Quantum potential different')
%%%%%%%%%%%%%%%Poltting
%plots

%force

