/* shiftcnt.c */
/* Code for shifting atoms in CNT so that none have negative x coordinates */
/* Kenny Higa, 13 Dec 2002 */

#include <stdio.h>

#define EPSILON 0.01

int main(int argc, char *argv[]) {

	double min, x, y, z, xnew;

	FILE *input, *output;

	if (argc != 3) {
		puts("shiftcnt < coordinate input file > < output file >\n");
		return 1;
	}

	if ((input = fopen(argv[1],"r")) == NULL) {
		printf("Error opening input file %s\n",	argv[1]);
		return 2;
	}

	if ((output = fopen(argv[2],"w")) == NULL) {
		printf("Error opening output file %s\n", argv[2]);
		return 2;
	}

	/*	first find particle with minimum x coordinate, shift all particles
		forward by the absolute value of this coordinate */

	min = 0.0;

	while ((fscanf(input,"%lf %lf %lf", &x, &y, &z)) != EOF) 

		if (x < min)
			min = x;

	/* 	go back to start of file */

	rewind(input);

	/* 	now shift all coordinates so that the minimum x coordinate of
		any atom is 0.0 
		
		put a "1" next to those atoms at x = 0, "0" otherwise.  This
		indicates which atoms are boundary atoms */
		

	while ((fscanf(input, "%lf %lf %lf", &x, &y, &z)) != EOF) {
	  xnew = x - min;

		fprintf(output,"%lf\t%lf\t%lf\t%c\n", xnew, y, z, ((xnew - 0.0) < EPSILON) ? '1' : '0');
	}

	/* finish nicely */

	fclose(input);
	fclose(output);

	return 0;
} 
