#include "parameter.h"
#define SWAP(a,b) tempr=(a);(a)=(b);(b)=tempr
#define Tpi 6.28318

float Pgrid[RBmax][ABin];

void polar()
{ int Rg,Rc2,R2,dr,RBin,x,y,i,j,Ri,Ai;
 FILE *fp;
 float tmp,max,normal[ABin/2+1];
 void realft();

 RBin=floor(Rcut0/DR)+1;  /*radiual bin number*/
 dr=DR*sub;               /*grid spacing=DR*sub */
 Rg=Rcut0*sub;Rc2=Rg*Rg; 

 for(i=0;i<RBin;i++)
   for(j=0;j<ABin;j++)
     Pgrid[i][j]=0;

 printf("RBin=%d,Rg=%d\n",RBin,Rg);
 for(i=1;i<Rg;i++) /*for walkers off x and y axes*/
   for(j=1;j<Rg;j++) 
     { R2=i*i+j*j;
       if(R2<Rc2)
	 {x=i+x00*sub;
          y=j+y00*sub;
	  Ri=floor(sqrt(R2)/dr);
          Ai=floor(atan(1.*j/i)/Tpi*ABin);
	  if(Grid[x][y]==OCCUPY)Pgrid[Ri][Ai]++; /* 1st quadrant*/ 
	  if(Grid[x-2*i][y]==OCCUPY)Pgrid[Ri][ABin/2-Ai]++; /*2nd*/
	  if(Grid[x][y-2*j]==OCCUPY)Pgrid[Ri][ABin-Ai]++;/*3rd*/
          if(Grid[x-2*i][y-2*j]==OCCUPY)Pgrid[Ri][ABin/2+Ai]++;/*4th*/
	  }
     } 
 
 for(i=1;i<Rg;i++)/* for walkers on x and y axes*/
   {x=i+x00*sub;y=y00*sub;Ri=floor(i/dr);
   if(Grid[x][y]==OCCUPY)Pgrid[Ri][0]++;
   if(Grid[x-2*i][y]==OCCUPY)Pgrid[Ri][ABin/2]++;
   if(Grid[y][x]==OCCUPY)Pgrid[Ri][ABin/4]++;
   if(Grid[y][x-2*i]==OCCUPY)Pgrid[Ri][3*ABin/4]++;
   }


 if((fp=fopen("polar_dis.dat","wb"))==NULL)
   {printf("Cannot open file\n");
    exit(0);}
 for(i=0;i<RBin;i++)/*export polar distribution to "polar_dist.dat*/
     for(j=0;j<ABin;j++)
        fprintf(fp,"%d %d %.0f\n",j,i,Pgrid[i][j]);
        
 fclose(fp);
 

 if((fp=fopen("polar_fft.dat","wb"))==NULL)
   {printf("Cannot open file\n");
    exit(0);}
 
 for(i=0;i<RBin;i++)
   {realft(Pgrid[i]-1,ABin); /*-1 to acoount for the zero offset of Pgrid*/
   max=0;
   for(j=1;j<ABin/2;j++)
     {tmp=sqrt(Pgrid[i][2*j]*Pgrid[i][2*j]+Pgrid[i][2*j+1]*Pgrid[i][2*j+1]);
     normal[j]=tmp;
     if(tmp>max)max=tmp;
     }
   normal[0]=0;/*minus the background*/
   normal[ABin/2]=abs(Pgrid[i][1]);/*extract last component of Fourier transform*/
   if(max==0)max=1;
   for(j=0;j<=ABin/2;j++)
     fprintf(fp,"%d %d %.2f\n",j,i,normal[j]*100/max);
  }
  fclose(fp);
   
 return;
}

/*1D fourier transform for real numbers. Codes are modified from " Numerical Recipe in C", by William H. Press, Saul A.Teukkolsky, William T. Vetterling and Brian P.Flannery */
void four1(float data[],unsigned long nn)/*nn must be power of 2*/
{
  unsigned long  n,mmax,m,i,j,istep;
  double wtemp,wr,wpr,wpi,wi,theta;
  float tempr,tempi;
  

  n=nn<<1;
  j=1;
  for(i=1;i<n;i+=2)
     {if(j>i)
          {SWAP(data[j],data[i]);
           SWAP(data[j+1],data[i+1]);
          }
      m=n>>1;
      while(m>=2&&j>m)
           {j-=m;
            m>>=1;
            }
       j+=m;
       }

    mmax=2;
    while(n>mmax)
       {istep=mmax<<1;
        theta=Tpi/mmax;
        wtemp=sin(0.5*theta);
        wpr=-2.0*wtemp*wtemp;
        wpi=sin(theta);
        wr=1.0;
        wi=0.0;
        for(m=1;m<mmax;m+=2)
            {for(i=m;i<=n;i+=istep)
               {j=i+mmax;
  		tempr=wr*data[j]-wi*data[j+1];
		tempi=wr*data[j+1]+wi*data[j];
        	data[j]=data[i]-tempr;
		data[j+1]=data[i+1]-tempi;
		data[i]+=tempr;
		data[i+1]+=tempi;
		}
		wr=(wtemp=wr)*wpr-wi*wpi+wr;
		wi=wi*wpr+wtemp*wpi+wi;
	     }
	  mmax=istep;
          }
}  	

void realft(float data[],unsigned long n)
{  int i,i1,i2,i3,i4,np3;
    float c1=.5,c2,h1r,h1i,h2r,h2i;
    double wr,wi,wpr,wpi,wtemp,theta;
   
    theta=(Tpi/2)/(double) (n>>1);
    c2 = -0.5;
    four1(data,n>>1); 

    wtemp=sin(0.5*theta);
    wpr = -2.0*wtemp*wtemp;
    wpi=sin(theta);
    wr=1.0+wpr;
    wi=wpi;
    np3=n+3;
    for (i=2;i<=(n>>2);i++) 
       {i4=1+(i3=np3-(i2=1+(i1=i+i-1)));
        h1r=c1*(data[i1]+data[i3]); 
	h1i=c1*(data[i2]-data[i4]);
	h2r = -c2*(data[i2]+data[i4]);
	h2i=c2*(data[i1]-data[i3]);
	data[i1]=h1r+wr*h2r-wi*h2i;
	data[i2]=h1i+wr*h2i+wi*h2r;
	data[i3]=h1r-wr*h2r+wi*h2i;
	data[i4] = -h1i+wr*h2i+wi*h2r;
	wr=(wtemp=wr)*wpr-wi*wpi+wr; 
	wi=wi*wpr+wtemp*wpi+wi;
       }
      data[1] = (h1r=data[1])+data[2]; 
      data[2] = h1r-data[2];
      return;
}



