/*
 *  ThomasAlg.cpp
 *  Diffusion
 *
 *  Created by Shane Stafford on Tue Nov 19 2002.
 *  Copyright (c) 2002. All rights reserved.
 *
 *  Description:  Solves tridiagonal matrices using the Thomas algorithm
 *                r = right hand side matrix
 *                efg = compressed tridiagonal (3 elements per row)
 *                x is filled with result
 */

#include "ThomasAlg.h"
#include "array2d.h"

void tridiagSolve( array2d< double >& efg, double *r, double *x, int begin, int end)
{
    //decompose
    for(int i = begin + 1; i<=end; i++) {
        efg(i,0) = efg(i,0) / efg(i-1,1);
        efg(i,1) = efg(i,1) - efg(i,0) * efg(i-1,2);
    }
    
    //forward substitute
    for(int i = begin + 1; i<=end; i++)
        r[i] = r[i] - efg(i,0) * r[i-1];
        
    //back substitute
    x[end] = r[end] / efg(end,1);
    for(int i = end-1; i>=begin; i--)
        x[i] = ( r[i] - efg(i,2) * x[i+1] ) / efg(i,1);
        
}
