/*
 *  array2d.cpp
 *  PointerTest
 *
 *  Created by Shane Stafford on Thu Nov 28 2002.
 *  Copyright (c) 2002. All rights reserved.
 *
 */

#include "array2d.h"
#include <iostream>

// name=default constructor
template< class eType >
array2d< eType >::array2d()
{
    M = 1;
    N = 1;
    array1d = new eType[ M * N ];
}

// name=constructor
// 	-N is size in first dimension, M is size in second
template< class eType >
array2d< eType >::array2d( int dim1, int dim2  )
{
    M = dim1;
    N = dim2;
    array1d = new eType[ N * M ];
}

// name=initialize
//	-all values will be initialized to initVal
template< class eType >
void array2d< eType >::initialize( eType initVal )
{
    for(int i = 0; i<(N*M); i++)
        array1d[i] = initVal;
}

// name=copy constructor
//	-make this a new copy of origVal
template< class eType >
array2d<eType>::array2d( const array2d<eType>& origVal )
{
    M = origVal.M;
    N = origVal.N;
    array1d = new eType[ M * N ];
    for(int i=0; i<(M*N); i++)
        array1d[i] = origVal.array1d[i];
}

// name=operator=
//	-overloading assignment operator
template< class eType >
array2d<eType>& array2d<eType>::operator=( const array2d<eType>& origVal )
{
    if(this != &origVal) {
        delete array1d;
        M = origVal.M;
        N = origVal.N;
        array1d = new eType[ M * N ];
        for(int i=0; i<(M*N); i++)
            array1d[i] = origVal.array1d[i];
    }
    return *this;
}

// name=destructor
//	-deallocate array memory
template< class eType >
array2d< eType >::~array2d()
{
    delete array1d;
}

// name=operator()
//	-overload parentheses for indexing
template< class eType >
eType& array2d<eType>::operator() ( int x, int y )
{
  //check bounds
  if( (x>=M) || (y>=N) || (x<0) || (y<0) ) {
    std::cout << "Array subscript out of bounds.\n";
    return array1d[ 0 ];
  }
  return array1d[ x*N + y ];
}

// name=operator() const
//	-overload parentheses for indexing
template< class eType >
eType array2d<eType>::operator() ( int x, int y ) const
{
  //check bounds
  if( (x>=M) || (y>=N) || (x<0) || (y<0) ) {
    std::cout << "Array subscript out of bounds.\n";
    return array1d[ 0 ];
  }
  return array1d[ x*N + y ];
}

// instantiate template classes
template class array2d< double >;
template class array2d< int >;

