/*
 *  array2d.h
 *  PointerTest
 *
 *  Created by Shane Stafford on Thu Nov 28 2002.
 *  Copyright (c) 2002. All rights reserved.
 *
 *  Implementation of a 2-D matrix of template eType.  Subscripting is via
 *  the parentheses operator, e.g. matrix(i,j) = element at i,j.
 *
 */
 
#ifndef _ARRAY2D_H
#define _ARRAY2D_H

template< class eType >
class array2d
{
public:
    array2d();						//default constructor
    array2d( int rows, int cols );			//constructor
    array2d( const array2d& origVal );			//copy constructor
    array2d& operator= ( const array2d& origVal );	//operator=
    ~array2d();						//destructor
    eType& operator() ( int x, int y );			//operator()
    eType operator() ( int x, int y ) const;		//operator()    
    void initialize( eType );				//initialize all elements
private:
    eType* array1d;
    int M, N;
};

#endif
