/*
 *  walker.h
 *  Active Walkers
 *
 *  Created by Shane Stafford on Wed Nov 27 2002.
 *  Copyright (c) 2002. All rights reserved.
 *
 */

#ifndef _WALKER_H
#define _WALKER_H

#include "array2d.h"


class walker
{
public:

    void setWalkerParams( double RepThresh, double InactThresh, 
                          double Uptake, double Metab, double Step, 
                          double EnergyInit, double EnergyReproduction,
                          int Hardness, array2d< int >* envLattice,
                          array2d< double >* foodLattice );
                     
    int step(  double rnd1, double rnd2, walker*& child );
    void getInfo( double& _x, double& _y, double& _energy );
    
    //constructors
    walker( double _x, double _y );
    walker( double _x, double _y, double _energy );

private:
    /**************** shared walker parameters ******************/
    static double repThreshold;			//reproduction threshold
    static double inactThreshold;		//unactivate threshold
    static double metabolism;			//energy usage rate
    static double maxUptake;			//maximum feeding rate
    static double maxStep;			//largest step size
    static double initEnergy;			//initial energy
    static double repEnergy;			//energy used for reproduction
    static int envHardness;			//envelope hardness in # of hits
    static array2d< int >* envelope;		//envelope lattice
    static array2d< double >* food;		//food lattice
    
    /************** individual walker parameters ****************/
    double x, y;				//coordinates
    double energy;				//energy
    
    walker();					//protect default constructor
    int metabolize();
    void move( double rnd1, double rnd2 );
    void eat();
    walker* reproduce(); 
};

#endif
